<?php
/* --------------------------------------------------------------
   LanguageService.php 2020-04-16
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Core\Language\Services;

use Gambio\Core\Language\Language;
use Gambio\Core\Language\LanguageRepository;
use Gambio\Core\Language\Languages;
use Gambio\Core\Language\Model\LanguageCode;
use Gambio\Core\Language\Model\LanguageId;
use Gambio\Core\Language\SqlCriteria\LanguageFilter;
use Gambio\Core\Language\SqlCriteria\LanguageFilters;
use Gambio\Core\Language\SqlCriteria\LanguageSorting;
use Gambio\Core\Language\SqlCriteria\LanguageSortings;
use Gambio\Core\Language\SqlCriteria\LanguageSqlCriteria;

/**
 * Class LanguageService
 *
 * @package Gambio\Core\Language
 */
class LanguageService implements \Gambio\Core\Language\LanguageService
{
    /**
     * @var LanguageRepository
     */
    private $repository;
    
    
    /**
     * LanguageService constructor.
     *
     * @param LanguageRepository $repository
     */
    public function __construct(LanguageRepository $repository)
    {
        $this->repository = $repository;
    }
    
    
    /**
     * @inheritDoc
     */
    public function getAvailableLanguages(): Languages
    {
        $filter   = LanguageFilters::create(LanguageFilter::create('status', '1', 'eq'));
        $sortings = LanguageSortings::create(LanguageSorting::create('sortOrder'));
        $criteria = LanguageSqlCriteria::create($filter, $sortings);
        
        return $this->repository->getAll($criteria);
    }
    
    
    /**
     * @inheritDoc
     */
    public function getAvailableAdminLanguages(): Languages
    {
        $filter   = LanguageFilters::create(LanguageFilter::create('statusAdmin', '1', 'eq'));
        $sortings = LanguageSortings::create(LanguageSorting::create('sortOrder'));
        $criteria = LanguageSqlCriteria::create($filter, $sortings);
        
        return $this->repository->getAll($criteria);
    }
    
    
    /**
     * @inheritDoc
     */
    public function getLanguageById(int $id): Language
    {
        return $this->repository->getById(LanguageId::create($id));
    }
    
    
    /**
     * @inheritDoc
     */
    public function getLanguageByCode(string $code): Language
    {
        return $this->repository->getByCode(LanguageCode::create($code));
    }
}